<report title="D2D 5.0 - Coded Depression" description="Lists patients with coded depression diagnosis."
active="1">
<query>

SELECT DISTINCT 
    d.demographic_no Demographic, 
    d.sex Sex, 
    floor(datediff(curdate(),str_to_date(concat(d.year_of_birth,d.month_of_birth,d.date_of_birth),'%Y%m%d'))/365.25) Age, 
    concat(d.last_name, ', ', d.first_name) Patient, 
    concat(p.last_name, ', ', p.first_name) MRP
FROM demographic d, provider p, dxresearch dx
WHERE  d.patient_status = 'AC' 
AND (dx.dxresearch_code IN ('2962', '2963', '2964', '3004', '311', 'F320', 'D9-52') AND dx.status = "A" AND d.demographic_no = dx.demographic_no)
AND d.provider_no = p.provider_no
ORDER by Demographic;
</query>

</report>